---
title: CASB Changelog · Cloudflare One docs
description: Review recent changes to Cloudflare CASB.
lastUpdated: 2025-10-24T15:44:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/changelog/casb/
  md: https://developers.cloudflare.com/cloudflare-one/changelog/casb/index.md
---

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/casb.xml)

## 2025-10-28

**CASB introduces new granular roles**

Cloudflare CASB (Cloud Access Security Broker) now supports two new granular roles to provide more precise access control for your security teams:

* **Cloudflare CASB Read:** Provides read-only access to view CASB findings and dashboards. This role is ideal for security analysts, compliance auditors, or team members who need visibility without modification rights.
* **Cloudflare CASB:** Provides full administrative access to configure and manage all aspects of the CASB product.

These new roles help you better enforce the principle of least privilege. You can now grant specific members access to CASB security findings without assigning them broader permissions, such as the **Super Administrator** or **Administrator** roles.

To enable [Data Loss Prevention (DLP)](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/), scans in CASB, account members will need the **Cloudflare Zero Trust** role.

You can find these new roles when inviting members or creating API tokens in the Cloudflare dashboard under **Manage Account** > **Members**.

To learn more about managing roles and permissions, refer to the [Manage account members and roles documentation](https://developers.cloudflare.com/fundamentals/manage-members/roles/).

## 2025-08-26

**New CASB integrations for ChatGPT, Claude, and Gemini**

[Cloudflare CASB](https://www.cloudflare.com/zero-trust/products/casb/) now supports three of the most widely used GenAI platforms — **OpenAI ChatGPT**, **Anthropic Claude**, and **Google Gemini**. These API-based integrations give security teams agentless visibility into posture, data, and compliance risks across their organization’s use of generative AI.

![Cloudflare CASB showing selection of new findings for ChatGPT, Claude, and Gemini integrations.](https://developers.cloudflare.com/_astro/casb-ai-integrations-preview.B-zsSA1P_Z1CkbtH.webp)

#### Key capabilities

* **Agentless connections** — connect ChatGPT, Claude, and Gemini tenants via API; no endpoint software required
* **Posture management** — detect insecure settings and misconfigurations that could lead to data exposure
* **DLP detection** — identify sensitive data in uploaded chat attachments or files
* **GenAI-specific insights** — surface risks unique to each provider’s capabilities

#### Learn more

* [ChatGPT integration docs](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/openai/)
* [Claude integration docs](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/anthropic/)
* [Gemini integration docs](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/google-workspace/gemini/)

These integrations are available to all Cloudflare One customers today.

## 2025-06-23

**Data Security Analytics in the Zero Trust dashboard**

Zero Trust now includes **Data security analytics**, providing you with unprecedented visibility into your organization sensitive data.

The new dashboard includes:

* **Sensitive Data Movement Over Time:**

  * See patterns and trends in how sensitive data moves across your environment. This helps understand where data is flowing and identify common paths.

* **Sensitive Data at Rest in SaaS & Cloud:**

  * View an inventory of sensitive data stored within your corporate SaaS applications (for example, Google Drive, Microsoft 365) and cloud accounts (such as AWS S3).

* **DLP Policy Activity:**

  * Identify which of your Data Loss Prevention (DLP) policies are being triggered most often.
  * See which specific users are responsible for triggering DLP policies.

![Data Security Analytics](https://developers.cloudflare.com/_astro/cf1-data-security-analytics-v1.BGl6fYXl_Z20un3h.webp)

To access the new dashboard, log in to [Zero Trust](https://one.dash.cloudflare.com/) and go to **Analytics** on the sidebar.

## 2024-11-22

**Find security misconfigurations in your AWS cloud environment**

You can now use CASB to find security misconfigurations in your AWS cloud environment using [Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/).

You can also [connect your AWS compute account](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/aws-s3/#compute-account) to extract and scan your S3 buckets for sensitive data while avoiding egress fees. CASB will scan any objects that exist in the bucket at the time of configuration.

To connect a compute account to your AWS integration:

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Cloud & SaaS findings** > **Integrations**.
2. Find and select your AWS integration.
3. Select **Open connection instructions**.
4. Follow the instructions provided to connect a new compute account.
5. Select **Refresh**.

## 2024-06-03

**Atlassian Bitbucket integration**

You can now scan your Bitbucket Cloud workspaces for a variety of contextualized security issues such as source code exposure, admin misconfigurations, and more.

## 2024-05-23

**Data-at-rest DLP for Box and Dropbox**

You can now scan your [Box](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/box/#data-loss-prevention-optional) and [Dropbox](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/dropbox/#data-loss-prevention-optional) files for DLP matches.

## 2024-04-16

**Export CASB findings to CSV**

You can now export all top-level CASB findings or every instance of your findings to CSV.
