---
title: Get started · Cloudflare Magic Cloud Networking docs
description: To get started with Magic Cloud Networking (beta) you need to give
  Cloudflare permission to interact with cloud providers on your behalf. You
  might have multiple provider accounts for the same cloud provider — for
  example, you might want Cloudflare to manage virtual private clouds (VPCs)
  belonging to two different AWS accounts.
lastUpdated: 2025-09-29T10:35:30.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-cloud-networking/get-started/
  md: https://developers.cloudflare.com/magic-cloud-networking/get-started/index.md
---

To get started with Magic Cloud Networking (beta) you need to give Cloudflare permission to interact with cloud providers on your behalf. You might have multiple provider accounts for the same cloud provider — for example, you might want Cloudflare to manage virtual private clouds (VPCs) belonging to two different AWS accounts.

Once Cloudflare has the credentials required to access your cloud environments, Magic Cloud Networking will automatically begin discovering your cloud resources — like routing tables and virtual private networks. Discovered resources appear in your [Cloud resource catalog](https://developers.cloudflare.com/magic-cloud-networking/manage-resources/#cloud-resource-catalog).

## Set up Amazon AWS

### 1. Create integration

1. In the Cloudflare dashboard, go to **Cloud integrations**.

   [Go to **Cloud integrations**](https://dash.cloudflare.com/?to=/:account/mcn/integrations)

2. Select **Add** > **AWS integration**.

3. Give a descriptive name to your integration. Optionally, you can also add a description for it.

4. Select **Create integration**.

5. Select **Authorize access** to start the process of connecting your Cloudflare account to Amazon AWS.

### 2. Create IAM policy

1. Create a [custom access policy](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_create-console.html) in your AWS account, and take note of the name you entered. Then, paste the following [JSON code](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_version.html) in the JSON tab:

```json
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "ec2:AcceptTransitGatewayPeeringAttachment",
                "ec2:CreateTransitGatewayPeeringAttachment",
                "ec2:DeleteTransitGatewayPeeringAttachment",
                "ec2:DescribeRegions",
                "ec2:DescribeTransitGatewayPeeringAttachments",
                "ec2:RejectTransitGatewayPeeringAttachment",
                "ec2:GetManagedPrefixListEntries",
                "ec2:CreateManagedPrefixList",
                "ec2:ModifyManagedPrefixList",
                "ec2:DeleteManagedPrefixList",
                "ec2:CreateTransitGatewayPrefixListReference",
                "ec2:DeleteTransitGatewayPrefixListReference",
                "ec2:GetTransitGatewayPrefixListReferences",
                "ec2:ModifyTransitGatewayPrefixListReference"
            ],
            "Resource": "*"
        }
    ]
}
```

### 3. Authorize access to your AWS account

1. Create a [custom access policy](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_create-console.html) in your AWS account, and take note of the name you entered.

2. Create an [AWS role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-custom.html) with the following settings:

   * **Trusted entity type**: Select **Custom trust policy**, and paste the custom trust policy returned by the Cloudflare dashboard.

   * **Permissions**: Add the IAM policy created in step 1, along with these AWS-managed policies:

     * `NetworkAdministrator`
     * `AmazonEC2ReadOnlyAccess`
     * `AmazonVPCReadOnlyAccess`
     * `IAMReadOnlyAccess`

   * **ARN**: Copy the ARN for your newly created user.

   Note

   The trust policy may take several minutes to propagate to all regions. It usually takes less than four minutes, but can sometimes take longer. You may have to retry the **Authorize** button while the propagation takes effect.

3. Select **I authorize Cloudflare to access my AWS account.**

4. Select **Authorize**.

The first discovery of resources may not succeed in all regions, while the IAM policy is propagating. If you do not see all resources after creating your cloud integration, please try re-discovering.

## Set up Microsoft Azure

### 1. Create integration

1. In the Cloudflare dashboard, go to **Cloud integrations**.

   [Go to **Cloud integrations**](https://dash.cloudflare.com/?to=/:account/mcn/integrations)

2. Select **Add** > **Azure integration**.

3. Give a descriptive name to your integration. Optionally, you can also add a description for it.

4. Select **Create integration**.

5. Select **Authorize access** to start the process of connecting your Cloudflare account to Microsoft Azure.

### 2. Authorize access to your Azure account

Warning

Magic Cloud does not support personal Microsoft accounts. Please sign in using a work or school account that is part of an Azure Entra Tenant.

1. Select **Create service principal**. You will be redirected to Microsoft's login page.

2. Enter your Azure credentials. If your account does not have administrator privileges, you may need to pass this link to an account that has administrator privileges.

3. The next screen lists Cloudflare required permissions to access your account. Select **Accept**.

4. [Add a role assignment](https://learn.microsoft.com/en-us/azure/role-based-access-control/role-assignments-portal). The purpose of this step is to give the app that you registered in step 1 permission to access your Azure Subscription.

   * In step 3 of the linked document, select the **Contributor** role from the **Privileged administrator roles** tab.
   * In step 4 of the linked document, search for `mcn-provider-integrations-bot-prod` when selecting members.

5. In **Provide account information**, enter the **Tenant ID** and **Subscription ID** you copied from step 4.

6. In **Verify account ownership**, [add the tags displayed in the Cloudflare dashboard](https://learn.microsoft.com/en-us/azure/azure-resource-manager/management/tag-resources-portal).

   Note

   The tags may take several minutes to propagate and become readable to Cloudflare. It usually takes less than four minutes, but can sometimes take longer. You may have to retry the **Authorize** button while the propagation takes effect.

7. Select **I authorize Cloudflare to access my AWS account.** If your account does not have administrator privileges, you may need to pass this link to an account that has administrator privileges.

8. Select **Authorize**.

The first discovery of resources may not succeed in all regions, while the IAM policy is propagating. If you do not see all resources after creating your cloud integration, please try re-discovering.

## Set up Google Cloud

### 1. Create integration

1. In the Cloudflare dashboard, go to **Cloud integrations**.

   [Go to **Cloud integrations**](https://dash.cloudflare.com/?to=/:account/mcn/integrations)

2. Select **Add** > **Google integration**.

3. Give a descriptive name to your integration. Optionally, you can also add a description for it.

4. Select **Create integration**.

5. Select **Authorize access** to start the process of connecting your Cloudflare account to Google Cloud.

### 2. Authorize access to your Google account

1. Create a new [GCP service account](https://cloud.google.com/iam/docs/service-accounts-create) in your **Google account** > **GCP Console** > **IAM & Admin** > **Service Accounts**.

2. Grant the new service account these roles:

   * `Compute Network Admin`
   * `Compute Viewer`

3. Under **IAM & Admin** > **Service Accounts**, select the service account you just created, and navigate to the **Permissions** tab.

4. Grant the **Service Account Token Creator** role to our bot account to allow it to impersonate this service account. Learn how to grant a specific role [in Google's documentation](https://cloud.google.com/iam/docs/manage-access-service-accounts#grant-single-role):
   * `mcn-integrations-bot-prod@mcn-gcp-01.iam.gserviceaccount.com`

5. In the **service account email field**, enter the email account that you used to create the GCP service account.

6. In the **Project ID field**, enter the [project ID](https://support.google.com/googleapi/answer/7014113?hl=en) associated with your project.

7. [Add the label](https://cloud.google.com/resource-manager/docs/creating-managing-labels#create-labels) displayed on the dash to your project.

8. Select **I authorize Cloudflare to access my GCP account.** If your account does not have administrator privileges, you may need to pass this link to an account that has administrator privileges.

9. Select **Authorize**.

You have successfully connected your cloud provider to Magic Cloud Networking. Cloud resources found by Magic Cloud Networking are available in the [Cloud resource catalog](https://developers.cloudflare.com/magic-cloud-networking/manage-resources/#cloud-resource-catalog).

The first discovery of resources may not succeed in all regions, while the IAM policy is propagating. If you do not see all resources after creating your cloud integration, please try re-discovering.

## Next steps

* [Set up Magic WAN](https://developers.cloudflare.com/magic-cloud-networking/cloud-on-ramps/) as an on-ramp to your cloud.
* [Manage resources](https://developers.cloudflare.com/magic-cloud-networking/manage-resources/) found by Magic Cloud Networking.
* [Edit](https://developers.cloudflare.com/magic-cloud-networking/manage-resources/#edit-cloud-integrations) cloud integrations.
